﻿/*
 * BASeCamp DeepUnzip
Copyright (c) 2011, Michael Burgwin
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    Neither the name of BASeCamp Corporation nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, 
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO 
 * EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 * */


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using Ionic.Zip;
namespace DeepUnzip
{
    public partial class frmDeepUnzip : Form
    {
        private TempDeleter td = new TempDeleter();
        public frmDeepUnzip()
        {
            InitializeComponent();
        }

        public void BrowseDialogClick(Object sender, EventArgs ea)
        {
            Button castsender = (Button)sender;
            TextBox editthis = (TextBox)castsender.Tag;

            FolderBrowserDialog fbd = new FolderBrowserDialog();
            fbd.RootFolder = Environment.SpecialFolder.MyComputer;
            if (fbd.ShowDialog(this) == DialogResult.OK)
            {
                String AcquiredFolder = fbd.SelectedPath;
                editthis.Text = AcquiredFolder;


            }
        }

        private void frmDeepUnzip_Load(object sender, EventArgs e)
        {
            cmdBrowseDest.Tag = txtDestination;
            cmdBrowseSource.Tag = txtSourceFolder;
        }
        private void AddMessage(String Message)
        {
            AddMessage(Message, 0);


        }
        private void AddMessage(String Message,int numindents)
        {
            if (Message == null) return;
            Message = new string(Enumerable.Repeat(' ', numindents * 4).ToArray()) + Message;
            Invoke((MethodInvoker)(() => 
            { 
                lstMessages.Items.Add(Message);
                lstMessages.SelectedIndex = lstMessages.Items.Count - 1;
                Invalidate(); 
                Update(); }));

        }
        private void cmdGo_Click(object sender, EventArgs e)
        {
            String SourceLook = txtSourceFolder.Text;
            String DestFolder = txtDestination.Text;
            if (!Directory.Exists(SourceLook))
            {
                MessageBox.Show("Source Directory does not exist.");
                return;
            }


            if (!Directory.Exists(DestFolder))
                Directory.CreateDirectory(DestFolder);

            lstMessages.Items.Clear();
            ExamineFolder_Async(SourceLook, DestFolder);
        }
        private void ExamineComplete()
        {
            AddMessage("Finished.");

        }
        private void ExamineFolder_Async(String SourceLook, String DestFolder)
        {
            Thread madethread = new Thread(() => 
            {
                try
                {
                    ExamineFolder(SourceLook, DestFolder);
                }
                catch (ThreadAbortException tae)
                {
                    AddMessage("Processing thread aborted.");

                }
                finally
                {
                    ExamineComplete();
                }
            
            });
            madethread.Start();


        }
        private void ExamineFolder(string SourceLook, string DestFolder)
        {
            DirectoryInfo DestDirectory = new DirectoryInfo(DestFolder);
            DirectoryInfo SourceDirectory = new DirectoryInfo(SourceLook);
            
            AddMessage("Source:" + SourceDirectory);
            AddMessage("Dest:" + DestDirectory);


            //look for all zip files.
            foreach (FileInfo loopfile in SourceDirectory.GetFiles("*.zip", SearchOption.AllDirectories))
            {
                AddMessage("ZIP Found:" + loopfile.FullName);
                try
                {
                    String zipbasename = Path.GetFileNameWithoutExtension(loopfile.Name);
                    //open a stream on the zipfile.
                    //ZipFile.Read can be used to get a ZipFile to a stream.
                    using (FileStream Zipstream = new FileStream(loopfile.FullName, FileMode.Open))
                    {
                        ExamineZip(Zipstream, zipbasename, DestDirectory.FullName, 1);
                    }
                } catch (Exception exx)
                {
                    AddMessage("Exception processing file, " + loopfile.Name + " " + exx.Message);
                }
            }
        }


        private void ExamineZip(Stream sourcestream, String NamePrefix, String DestinationFolder,int numindent)
        {
            ZipFile readzip = ZipFile.Read(sourcestream);
            //extract all the files from this zip to zipfolder.
            //if we find a Zipfile within it, open it's stream and recurse on this routine.
            foreach (var iterateentry in readzip.Entries)
            {
                AddMessage("Inner File:" + iterateentry.FileName + " found.",numindent);
                if (!iterateentry.IsDirectory)
                {

                    String assemblefilename = Path.Combine(DestinationFolder,
                        NamePrefix + "_" + Path.GetFileNameWithoutExtension(iterateentry.FileName)) + Path.GetExtension(iterateentry.FileName);
                    String noextension = Path.GetFileNameWithoutExtension(iterateentry.FileName);

                    if (iterateentry.FileName.EndsWith(".zip", StringComparison.OrdinalIgnoreCase))
                    {
                        
                        //extract to temporary file.
                        String useziptemp = td.GetTempName("zip");
                        FileStream useoutput = new FileStream(useziptemp,FileMode.Create);
                        iterateentry.Extract(useoutput);
                        useoutput.Close();
                        
                        using (FileStream gotstream = new FileStream(useziptemp,FileMode.Open))
                        {
                            //assume a zip.
                            try
                            {
                                ExamineZip(gotstream, NamePrefix + "_" + noextension, DestinationFolder,numindent+1);


                            }
                            catch (Exception exx)
                            {
                                //might not have been a zip. Extract it normally.

                                using (FileStream outstream = new FileStream(assemblefilename, FileMode.Create))
                                {
                                    iterateentry.Extract(outstream);
                                }
                            }
                        }
                    }
                    else
                    {
                        using (FileStream outstream = new FileStream(assemblefilename, FileMode.Create))
                        {
                            iterateentry.Extract(outstream);

                        }
                    }

                }
            }


        }

        private void cmdExit_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

    }


    public class TempDeleter:IDisposable 
    {
        private List<String> Deletethesefiles = new List<string>(); 
        private bool _Disposed = false;

        public String GetTempName(String useextension)
        {
            String returnpath="";
            if (!useextension.StartsWith(".")) useextension = "." + useextension;
            do
            {
                returnpath = Path.GetTempFileName();
                Deletethesefiles.Add(returnpath);
                returnpath = Path.Combine(Path.GetTempPath(), Path.GetFileNameWithoutExtension(returnpath) + useextension);
            } while (File.Exists(returnpath));

            Deletethesefiles.Add(returnpath);
            return returnpath;


        }


       ~TempDeleter()
       {

           Dispose();

        }
        public void Dispose()
        {
            if (_Disposed) return;
            _Disposed = true;

            foreach (String filedel in Deletethesefiles)
            {

                try
                {
                    File.Delete(filedel);


                }
                catch
                {

                }
                

            }





        }





    }

}
